<?php

class Aops {


	public static $dbVersion = '2.0';
	const OPTIONS_VERSION = '8';

	public static $postTypeName = 'aops_content_upgrade';

	public static $prefix = 'aops_cu_';
	public static $metaPrefix = 'aops_cu_meta';

	const STATUS_UNKNOWN = 1;
	const STATUS_FAIL = 2;
	const STATUS_OK = 3;

	// DB tables used by plugin
	const TABLE_LOGS		= 'cu_logs';
	const TABLE_ENTRIES	= 'cu_entries';

	/**
	 *  array( optionId => optionDescriptionText [optional] )
	 */
	public static $pluginOptions = array(

	// General settings
		'load_cu_main_page'			=> '',							// checkbox
		'load_cu_category_page'		=> '',							// checkbox
		'load_cu_date_page'		=> '',								// checkbox
		'load_cu_on_a_template'		=> '',							// text input
		'facebook_conversion_event_enabled'	=> '',					// checkbox
		'facebook_conversion_event_name'	=> '',					// text input
		'google_analytics_submit_event_enabled'	=> '',				// checkbox

		'global_conversion_event_enabled'	=> '',					// checkbox
		'global_conversion_event_code'		=> '',					// textarea

		'download_enabled'					=> '',					// checkbox
		'download_text'						=> '',					// textarea

		'share_buttons_enabled'				=> '',					// checkbox
		'share_buttons_header_text'			=> '',					// text input
		'exit_popup_enabled'				=> '',					// checkbox
		'consent_checkbox_enabled'		=> '', 					// checkbox
		'consent_checkbox_label'		=> '',					//  text input

	// Email options
		'user_email_enabled'	=> '',								// checkbox
		'admin_email'			=> 'Default Administrator Email',	// text input
		'from_email'			=> 'From email',					// text input
		'from_name'				=> 'From name',						// text input
		'button_default_text'	=> 'Default button text',			// text input

		// default email to the user
		'default_email_subject' => '',								// rich text editor
		'default_email_body'	=> '',								// rich text editor

		// default email to the administrator
		'default_admin_email_enabled'	=> '',						// checkbox
		'default_admin_email_subject'	=> '',						// rich text editor
		'default_admin_email_body'		=> '',						// rich text editor

	// Box options
		'box_bg_color'			=> 'Box background color',			// color picker
		'box_border_color'		=> 'Box border color',				// color picker
		'box_border_style'		=> '',								// selection: solid, dashed, dotted
		'box_border_width'		=> '',								// text input
		'box_text_color'		=> 'Box text color',				// color picker
	// Button options
		'btn_bg_color'			=> 'Button background color',		// color picker
		'btn_text_color'		=> 'Button text color',				// color picker
		'btn_hover_bg_color'	=> 'Button hover background color',	// color picker
		'btn_hover_text_color'	=> 'Button hover text color',		// color picker
	// CSS options
		'css_custom_content'	=> '',								// textarea
		'css_disabled'			=> '',								// checkbox

	// Drip integration
		'drip_account_id'		=> '',								// text input
		'drip_status'			=> '',								// no input, for internal use
		'drip_default_tags'		=> '',								// text input
		'drip_global_event'		=> '',								// text input
		'drip_script_disabled'	=> '',								// checkbox

	// ConvertKit integration
		'convertkit_api_key'		=> '',							// text input
		'convertkit_status'			=> '',							// no input, for internal use
		'convertkit_form_list'		=> '',							// no input, for internal use
		'convertkit_default_formid'	=> '',
		'convertkit_forms'			=> '',
		'convertkit_tag_ids'		=> '',							// no input, for internal use
		'convertkit_default_tag_ids'=> '',							// multiple dropdown

	// Mailchimp integration
		'mailchimp_api_key'		=> '',								// text input
		'mailchimp_status'		=> '',								// no input, for internal use
		'mailchimp_default_list'	=> '',
		'mailchimp_default_groups'	=> '',
		'mailchimp_default_extra_list_id' => '',					// text field to directly specify List Id(hidden by default)
		'mailchimp_default_extra_list_status' => '',				// for internal use,
		'ssl_connection_disabled'	=> '',							// checkbox
		'ssl_connection_status'	=> '',								// for internal use

	// Zapier Integration
		'zapier_webhook_url'	=> '',								// text input
		'zapier_individual_cus' => '',								// checkbox

	// Misc options
		'enable_logging'					=> '',								// checkbox
		'disable_event_listener'	=> '',								// checkbox
		'enable_html5_validation'	=> '',								// checkbox
		'enable_default_jquery_version'	=> '',					// checkbox
		'check_custom_fields_for_cus'	=> '',						// checkbox

	// For internal use (remember which tab was opened)
		'last_opened_settings_tab' => '',
		'options_version'			=> ''			// used for upgrading
	);

	/**
	 *  array( colorPickerId )
	 *  used in AopsSettingsPage::prepareDesignFields()
	 */
	public static $colorPickers = array(
		'box_bg_color',
		'box_border_color',
		'box_text_color',
		'btn_bg_color',
		'btn_text_color',
		'btn_hover_bg_color',
		'btn_hover_text_color'
	);

	/**
	 * Later (when code is executed )added also:
	 *	- mailchimp_list
	 *  - mailchimp_group_title
	 *  - mailchimp_groups
	 *
	 * @var array
	 */
	public static $dropdownOptions = array(
		'box_border_style' => array(
			'solid'		=> 'solid',
			'dashed'	=> 'dashed',
			'dotted'	=> 'dotted'
		)
	);

	/**
	 *  array( optionId => optionDescriptionText [optional] )
	 */
	public static $pluginDefaultOptionValues = array(
	// General settings
		'load_cu_main_page'					=> 0,							// checkbox
		'load_cu_category_page'				=> 0,							// checkbox
		'load_cu_date_page'					=> 0,							// checkbox
		'load_cu_on_a_template'				=> '',							// text input
		'facebook_conversion_event_enabled'	=> 0,							// checkbox
		'facebook_conversion_event_name'	=> 'Content Upgrade Opt-in',	// text input
		'google_analytics_submit_event_enabled'	=> 0,						// checkbox

		'global_conversion_event_enabled'	=> 0,							// checkbox
		'global_conversion_event_code'		=>
			"ga('send', 'event', 'Content Upgrade', 'Click', 'Custom Event Description' , {'NonInteraction': 1});",		// textarea

		'button_default_text' => 'Send me the bonus!',						// text input

		'download_enabled'					=> 1,							// checkbox
		'download_text'						=> 'Download your bonus content:

{bonus_content_title_link}

Enjoy!',																	// textarea
		'share_buttons_enabled'				=> 1,							// checkbox
		'share_buttons_header_text'			=> "Share this article:",		// text input

		'exit_popup_enabled'				=> 1,
		'consent_checkbox_enabled'		=> 0,
		'consent_checkbox_label'		=> 'I consent to my contact information being collected.',

	// Email

		'user_email_enabled'	=> 1,							// checkbox
		// default email to the user
		'default_email_subject' => 'Here\'s your bonus: {content_upgrade_title}',	// rich text editor
		'default_email_body'	=> "Hi {user_first_name},

Here is the bonus content you requested.  You can download it here:

{bonus_content_title_link}

Enjoy!",								// rich text editor

		// default email to the administrator
		'default_admin_email_enabled'	=> 0,						// checkbox
		'default_admin_email_subject'	=> '[Content Upgrade Entry] {user_first_name}, {user_email}',						// rich text editor
		'default_admin_email_body'		=> "Someone requested a content upgrade!

Title: {content_upgrade_title}
First Name:  {user_first_name}
Email:  {user_email}
Date:  {date_of_entry}",						// rich text editor



	// Box options
		'box_bg_color'			=> '#ffffff',						// color picker
		'box_border_color'		=> '#999999',						// color picker
		'box_border_style'		=> 'dashed',						// selection: solid, dashed, dotted
		'box_border_width'		=> '1px',							// text input
		'box_text_color'		=> '#666666',						// color picker
	// Button options
		'btn_bg_color'			=> '#64d2a6',						// color picker
		'btn_text_color'		=> '#ffffff',						// color picker
		'btn_hover_bg_color'	=> '#8bffd1',						// color picker
		'btn_hover_text_color'	=> '#ffffff',						// color picker
	// CSS options
		'css_custom_content'	=> '',								// textarea
		'css_disabled'			=> 0,								// checkbox

	// Drip integration
		'drip_account_id'		=> '',								// text input
		'drip_status'			=> self::STATUS_UNKNOWN,			// for internal use
		'drip_default_tags'		=> '',								// text input
		'drip_global_event'		=> '',								// text input
		'drip_script_disabled'	=> 1,								// checkbox

	// ConvertKit integration
		'convertkit_api_key'		=> '',							// text input
		'convertkit_status'			=> self::STATUS_UNKNOWN,		// no input, for internal use
		'convertkit_form_list'		=> '',							// no input, for internal use
		'convertkit_default_formid'	=> 0,
		'convertkit_forms'			=> '',
		'convertkit_tag_ids'		=> array(),						// no input, for internal use
		'convertkit_default_tag_ids'=> array(),						// multiple dropdown

	// Mailchimp integration
		'mailchimp_api_key'		=> '',								// text input
		'mailchimp_status'		=> self::STATUS_UNKNOWN,			// for internal use
		'mailchimp_default_list'	=> '',
		'mailchimp_default_groups'	=> '',
		'mailchimp_default_extra_list_id' => '',					// text field to directly specify List Id(hidden by default)
		'mailchimp_default_extra_list_status' => self::STATUS_UNKNOWN,	// for internal use,
		'ssl_connection_disabled'	=> 0,							// checkbox
		'ssl_connection_status'	=> '',								// for internal use

	// Zapier Integration
		'zapier_webhook_url'		=> '',							// text input
		'zapier_individual_cus'		=> 0,							// checkbox

	// Misc Options
		'enable_logging' => 1,												// checkbox
		'disable_event_listener' => 0,								// checkbox
		'enable_html5_validation'	=> 0,								// checkbox
		'enable_default_jquery_version'	=> 0,					// checkbox
		'check_custom_fields_for_cus'	=> 0,						// checkbox

	// For internal use (remember which tab was opened)
		'last_opened_settings_tab'	=> '#tab_design',
		'options_version'			=> self::OPTIONS_VERSION

	);


	public static $pluginFreshUpdateOptionValues = array(
		'share_buttons_enabled'		=> 1,
		'download_enabled'				=> 1,
		'exit_popup_enabled'			=> 1,
		'user_email_enabled'			=> 1,
		'ssl_connection_disabled'	=> 0,
		'ssl_connection_status'		=> '',
		'enable_logging'					=> 1

	);

	public static $pluginPartialUpdateOptionValues = array(
		'2' => array( // when updating options from version 2 to version 3
			'ssl_connection_disabled'	=> 0		// create a new option with value 0
		),
		'3' => array( // when updating options from version 2/3 to version 4
			'ssl_connection_status'	=> '',
			'ssl_connection_disabled'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
		),
		'4' => array( // when updating options from version 2/3/4 to version 5
			'ssl_connection_status'	=> '',
			'ssl_connection_disabled'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'google_analytics_submit_event_enabled' => 0
		),
		'5' => array( // when updating options from version 2/3/4/5 to version 6
			'ssl_connection_status'	=> '',
			'ssl_connection_disabled'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'google_analytics_submit_event_enabled' => 0,
			'convertkit_api_key'		=> '',
			'convertkit_status'			=> self::STATUS_UNKNOWN,
			'convertkit_form_list'		=> '',
			'convertkit_forms'			=> '',
			'convertkit_default_formid'	=> 0,
			'convertkit_tag_ids'		=> array(),
			'convertkit_default_tag_ids'=> array()
		),
		'6' => array( // when updating options from version 2/3/4/5/6 to version 7
			'ssl_connection_status'	=> '',
			'ssl_connection_disabled'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'google_analytics_submit_event_enabled' => array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_api_key'		=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_status'			=> self::STATUS_UNKNOWN,
			'convertkit_form_list'		=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_forms'			=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_default_formid'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_tag_ids'		=> array(),
			'convertkit_default_tag_ids'=> array(),
			'consent_checkbox_enabled' => 0,
			'consent_checkbox_label' => 'I consent to my contact information being collected'

			/* example of option to be changed upon update

			 'some_test_value'	=> array(
				'fresh',			// default value for fresh install
				'update_value',		// instructions what to do if this options already exists
				'new'				// new value
			)
			 */
		),
		'6' => array( // when updating options from version 2/3/4/5/6/7 to version 8
			'ssl_connection_status'	=> '',
			'ssl_connection_disabled'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'google_analytics_submit_event_enabled' => array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_api_key'		=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_status'			=> self::STATUS_UNKNOWN,
			'convertkit_form_list'		=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_forms'			=> array(
				'',					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_default_formid'	=> array(
				0,					// default value for fresh install
				'keep_current'		// instructions what to do if this options already exists
			),
			'convertkit_tag_ids'		=> array(),
			'convertkit_default_tag_ids'=> array(),
			'consent_checkbox_enabled' => 0,
			'consent_checkbox_label' => 'I consent to my contact information being collected',
			'enable_logging' => 1
			/* example of option to be changed upon update

			 'some_test_value'	=> array(
				'fresh',			// default value for fresh install
				'update_value',		// instructions what to do if this options already exists
				'new'				// new value
			)
			 */
		),

	);


	public static $pluginUpdateMetadataValues = array(
		'user_email_enabled'		=> 1
	);

	/**
	 * Fields used in Custom Upgrade Posts
	 * @var array
	 */
	public static $metaFields = array(

	//Popup settings
		'headline',
		'description',
		'button_text',
		'preload_page_ids',

		'download_enabled',
		'download_text',

		'share_buttons_enabled',
		'share_buttons_header_text',

		'redirect_after_formfill_enabled',
		'redirect_after_formfill_url',

		'exit_popup_enabled',

	// Misc settings
		'facebook_conversion_event_enabled',
		'facebook_conversion_event_name',
		'google_analytics_submit_event_enabled',
		'custom_conversion_event_enabled',
		'custom_conversion_event_code',

	// Email settings
		'user_email_enabled',
		'user_email_subject',
		'user_email_body',
		'admin_email_enabled',
		'admin_email_address',
		'admin_email_subject',
		'admin_email_body',

	// Drip
		'drip_first_name_field_id',
		//'drip_email_field_id',
		'drip_custom_event_enabled',
		'drip_custom_event_name',
		'drip_tag_enabled',
		'drip_tag',

	// ConvertKit integration
		'convertkit_tag_enabled',
		'convertkit_tag_ids',							// multiple dropdown
		'convertkit_form_id',

	// Mailchimp
		'mailchimp_list',
		'mailchimp_extra_list_id',	// text field to directly specify List Id(hidden by default)
		'mailchimp_extra_list_status',
		'mailchimp_group_title',
		'mailchimp_groups',
		'mailchimp_list_groups', // for internal use - to save relation berween lists and groups (which is which)

	// Zapier Integration
		'zapier_individual_webhook_url',	// text input

	// Bonus content
		'bonus_content_path',

	// For internal use (remember which tab was opened)
		'last_opened_tab'
	);

	/**
	 * Keys for default values of meta fields
	 * array('ID of meta fiels' => 'default value')
	 * @var array
	 */
	public static $defaultMetaValues = array(
		'download_enabled'	=> 1,
	);

	/***** for Edit Content Upgrade Page *****/

	/**
	 * List of checkboxes
	 * checkboxes don`t show in POST array if not checked, so we keep a list of them
	 * to check whether they are presented in POST array when saving a CU intem
	 * @var array
	 */
	public static $checkboxes = array(
		'facebook_conversion_event_enabled',
		'google_analytics_submit_event_enabled',
		'custom_conversion_event_enabled',
		'user_email_enabled',
		'admin_email_enabled',
		'drip_custom_event_enabled',
		'drip_tag_enabled',
		'convertkit_tag_enabled',
		'download_enabled',
		'share_buttons_enabled',
		'redirect_after_formfill_enabled',
		'exit_popup_enabled'
	);

	/**
	 * List of "multiple" selects
	 * These selects don`t show in POST array if no options selected in them, so we keep a list
	 * to check whether they are presented in POST array when saving a CU intem
	 * @var array
	 */
	public static $multiples = array(
		'convertkit_tag_ids'
	);

	/**
	 * Indicates whether plugin options are already loaded and saved into a cache
	 * @var boolean
	 */
	public static $optionsAreCached = false;

	/**
	 * Stores loaded plugin options
	 * @var array
	 */
	public static $cachedOptions = array();

	/**
	 * For Bulk Edit
	 * keys are names of checkboxes inputs in 'Bulk Edit' section
	 *
	 * NOTE - don't forget to update aops-admin.js when updating this list
	 */
	public static $bulkEditCheckboxes = array(
									// 'name' is the name of the corresponding meta value to be changed upon bulk edit request
									// 'title' is the title of the checkbox
		'cu_user_email_status'		=> array('name' => 'user_email_enabled', 'title' => 'Send email to user'),
		'cu_admin_email_status'		=> array('name' => 'admin_email_enabled', 'title' => 'Send email to administrator'),
		'cu_exit_intent_status'		=> array('name' => 'exit_popup_enabled', 'title' => 'Exit-intent popup'),
		'cu_download_status'		=> array('name' => 'download_enabled', 'title' => 'Download link'),
		'cu_sharing_status'			=> array('name' => 'share_buttons_enabled', 'title' => 'Social sharing buttons'),
		'cu_ga_event_status'		=> array('name' => 'google_analytics_submit_event_enabled', 'title' => 'Fire GA event when submitted'),
	);

	/**
	 * Get meta fields values for 'aops_content_upgrade' post type .
	 * @param integer $post_id
	 * @return array
	 */
	public static function getMeta($post_id, $needDefaultValues = false) {

		$meta = array(
			'title'	=> get_the_title($post_id)
		);

		foreach (self::$metaFields as $field) {
			$meta[$field] = get_post_meta( $post_id, self::$metaPrefix . '_' . $field, true );
			if ($needDefaultValues && isset(self::$defaultMetaValues[$field])) { // handle situation when post is just created and there is need to get default values
				$meta[$field] = self::$defaultMetaValues[$field];
			}
		}

		return $meta;
	}


	/**
	 * Gets plugin options and settings from the cache, or load from database if cache is empty.
	 * @return array
	 */
	public static function getOptions() {

 		$opts = array();
 		if ( ! self::$optionsAreCached ) {
			self::$cachedOptions = self::loadOptions();
			self::$optionsAreCached = true;
		}

 		return self::$cachedOptions;
 	}

	public static function loadOptions() {
		$opts = array();
		foreach (self::$pluginOptions as $optionId => $optionDescription) {
			$opts[$optionId] = get_option(self::$prefix . $optionId);
		}
		return $opts;
	}

	public static function checkIfSslDisabled() {
		return get_option(self::$prefix . 'ssl_connection_disabled', false);
	}


	/**
	 * Saves plugin option
	 */
	public function saveOption($optionId, $optionValue) {
		return update_option(self::$prefix . $optionId, $optionValue);
	}

	/**
	 * Generates HTML code before field input in table
	 * @param array $field
	 */
	public function makeField($field, $value) {
		if ( isset( $field['label'] ) ) {
			$label = __($field['label'], 'aops');
		}
		else {
			$label = '[Label not set]';
		}

		// 1. Make HTML for input
		switch ($field['type']) {
			case 'checkbox':
			case 'checkbox_with_tooltip':
				$inputHTML = $this->makeCheckbox($field, $value);
				break;
			case 'checkbox_with_text':
				$inputHTML = $this->makeCheckboxWithText($field, $value);
				break;
			case 'mailchimp_checkboxes_array':
				$inputHTML = $this->makeMailchimpCheckboxesArray($field,$value);
				break;
			case 'text':
				$inputHTML = $this->makeTextField($field, $value);
				break;
			case 'text_with_check':
				$inputHTML = $this->makeTextFieldWithCheck($field, $value);
				break;
			case 'hidden_until_toggle_text':
				$inputHTML = $this->makeTextField($field, $value);
				break;
			case 'dropdown':
				$inputHTML = $this->makeDropdownField($field, $value);
				break;
			case 'mailchimp_dropdown':
				$inputHTML = $this->makeMailchimpDropdownField($field, $value);
				break;
			case 'color':
				$inputHTML = $this->makeColorPickerField($field, $value);
				break;
			case 'textarea':
				$inputHTML = $this->makeTextareaField($field, $value);
				break;
			case 'copy_textarea':
				$inputHTML = $this->makeCopyTextareaField($field);
				break;
			case 'rich_textarea':
				$inputHTML = $this->makeRichTextareaField($field, $value);
				break;
			case 'footnote':
				$inputHTML = $this->makeFootnote($field);
				break;
			case 'content_uploader':
				$inputHTML = $this->makeContentUploader($field, $value);
				break;
			case 'hidden':
				$inputHTML = $this->makeHiddenField($field, $value);
				break;
			default:
				$inputHTML = '[Unknown field type "' . $field['type'] . '" ]';
		}

		if (isset($field['display'])) {
			$display = ($field['display']) ? 'table-row' : 'none';
		}
		else {
			$display = 'table-row';
		}

		// 2. Make HTML for table row
		switch ($field['type']) {
			case 'content_uploader':
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td colspan="3" class="non-table-content"><p>{$field['description']}</p> {$inputHTML}</td>
		</tr>
EOT;
				break;
			case 'checkbox':
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td colspan="3" class="col-checkbox">{$inputHTML}<label for="aops_{$field['id']}">$label</label></td>
		</tr>
EOT;
				break;
			case 'checkbox_with_tooltip':
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td colspan="3" class="col-checkbox">{$inputHTML}<label for="aops_{$field['id']}">$label</label>
			<a href="javascript:void(0)" class="aops-tooltip">
				<span class="info-icon">?</span>
				<span class="tooltip-body">{$field['description']}</span>
			</a></td>
		</tr>
EOT;
				break;
			case 'copy_textarea':
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td class="col-name"><label for="aops_{$field['id']}">$label</label></td>
			<td class="col-input">{$inputHTML}
				<a href="javascript:void(0)" class="button button-primary button-large" id="aops_copy_{$field['id']}" data-clipboard-text="{$field['default']}">Copy</a></td>
			<td class="col-info">
				<a href="javascript:void(0)" class="aops-tooltip">
					<span class="info-icon">?</span>
					<span class="tooltip-body">{$field['description']}</span>
				</a>
			</td>
		</tr>
EOT;
				break;
			case 'footnote':
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td colspan="3" class="col-footnote">{$inputHTML}</td>
		</tr>
EOT;
				break;
			case 'hidden':
				$tableRowHTML = <<<EOT
		<tr class="row-hidden">
			<td colspan="3" class="col-hidden">{$inputHTML}</td>
		</tr>
EOT;
				break;
			case 'hidden_until_toggle_text':
				$tableRowHTML = <<<EOT
		<tr id="hidden_{$field['id']}" style="display:none;">
			<td class="col-name"><label for="aops_{$field['id']}">$label</label></td>
			<td class="col-input">{$inputHTML}</td>
			<td class="col-info">
				<a href="javascript:void(0)" class="aops-tooltip">
					<span class="info-icon">?</span>
					<span class="tooltip-body">{$field['description']}</span>
				</a>
			</td>
		</tr>
EOT;
				break;
			case 'color':
			case 'dropdown':
			case 'text_with_check':
			case 'text':
			case 'textarea':
			case 'rich_textarea':
			case 'checkbox_with_text':
			case 'mailchimp_dropdown':
			case 'mailchimp_checkboxes_array':
			default:
				if (isset($field['description'])) {
					$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td class="col-name"><label for="aops_{$field['id']}">$label</label></td>
			<td class="col-input">{$inputHTML}</td>
			<td class="col-info">
				<a href="javascript:void(0)" class="aops-tooltip">
					<span class="info-icon">?</span>
					<span class="tooltip-body">{$field['description']}</span>
				</a>
			</td>
		</tr>
EOT;
				}
				else {
				$tableRowHTML = <<<EOT
		<tr style="display:{$display}">
			<td class="col-name"><label for="aops_{$field['id']}">$label</label></td>
			<td class="col-input">{$inputHTML}</td>
			<td class="col-info"></td>
		</tr>
EOT;
				}
		}


		return $tableRowHTML;
	}


	/**
	 * Generates HTML code for checkbox
	 * @param array $field
	 */
	public function makeCheckbox($field, $value) {
		$value = $value ? 'checked="checked"' : '';
		$out = <<<EOT
			<input type="checkbox" id="aops_{$field['id']}" name="{$field['name']}" {$value} value="1" class="cu-checkbox-field"/>
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for checkbox
	 * @param array $field
	 */
	public function makeCheckboxWithText($field, $value) {
		$value = $value ? 'checked="checked"' : '';
		$out = <<<EOT
			<input type="checkbox" id="aops_{$field['id']}" name="{$field['name']}" {$value} value="1" class="cu-checkbox-field"/>
			{$field['text']}
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for color picker
	 * @param array $field
	 */
	public function makeColorPickerField($field, $value) {
		$out = <<<EOT
			<input type="text" id="aops_{$field['id']}" name="{$field['name']}" value="{$value}" class="cu-color-picker">
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for text field input
	 * @param array $field
	 */
	public function makeTextField($field, $value) {
		$value = htmlspecialchars($value);
		$out = <<<EOT
			<input type="text" id="aops_{$field['id']}" name="{$field['name']}" size="{$field['size']}" value="{$value}" class="cu-text-field">
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for text field input
	 * @param array $field
	 */
	public function makeHiddenField($field, $value) {
		$value = htmlspecialchars($value);
		$out = <<<EOT
			<input type="hidden" id="aops_{$field['id']}" name="{$field['name']}" value="{$value}">
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for footnote
	 * @param array $field
	 */
	public function makeFootnote($field) {
		$out = <<<EOT
			<span class="aops-footnote">{$field['default']}</span>
EOT;
		return $out;
	}


	/**
	 * Generates HTML code for text field input
	 * @param array $field
	 */
	public function makeTextFieldWithCheck($field, $value) {
		$result = $this->checkTextField($field, $value);
		if ($result == self::STATUS_OK) {
			$check = '<span class="check-result-ok">&#x2713;</span>';
		}
		elseif ($result == self::STATUS_FAIL) {
			$check = '<span class="check-result-fail">&times;</span>';
		}
		else {
			$check = '';
		}
		$out = <<<EOT
			<input type="text" id="aops_{$field['id']}" name="{$field['name']}" size="{$field['size']}" value="{$value}" class="cu-text-field">{$check}
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for select input
	 * @param array $field
	 */
	public function makeDropdownField($field, $value) {

		if ( isset($field['multiple']) && $field['multiple']) {
			return $this->makeMultipleDropdownField($field, $value);
		}

		$out = '<select name="' . $field['name'] . '" id="aops_' . $field['id'] . '" >';

		foreach (self::$dropdownOptions[$field['id']] as $optionValue => $optionName) {

			$selected = ((string)$value == (string)$optionValue) ? 'selected="selected"' : '';

			$out .= '<option ' . $selected . ' value="' . $optionValue . '">' . $optionName .'</option>';
		}

		$out .= '</select>';
		return $out;
	}

	/**
	 * Generates HTML code for "multiple" select input
	 * @param array $field
	 */
	public function makeMultipleDropdownField($field, $value) {

		$multiple = 'multiple="multiple" size="' . $field['multiple'];

		if ( ! is_array($value) ) {
			$value = (array) $value;
		}

		// note the [] in select name
		$out = '<select name="' . $field['name'] . '[]" id="aops_' . $field['id'] . '" ' . $multiple . '>';

		foreach (self::$dropdownOptions[$field['id']] as $optionValue => $optionName) {

			$selected = in_array( $optionValue, $value ) ? 'selected="selected"' : '';

			$out .= '<option ' . $selected . ' value="' . $optionValue . '">' . $optionName .'</option>';
		}

		$out .= '</select>';
		return $out;
	}


	/**
	 * Generates HTML code for select input
	 * @param array $field
	 */
	public function makeMailchimpDropdownField($field, $value) {
		$out = '<select name="' . $field['name'] . '" id="aops_' . $field['id'] . '">';

		$firstKeyList = self::$dropdownOptions[$field['first_key']];
		$secondKeyList = self::$dropdownOptions[$field['second_key']];

		foreach ($firstKeyList as $optionGroupId => $optGroupName) {

			$out .= '<optgroup label="List: ' . $optGroupName . '">';

			foreach ($secondKeyList[$optionGroupId] as $optionValue => $optionName) {
				$selected = ($value == $optionValue) ? 'selected="selected"' : '';
				$out .= '<option '. $selected .' value="' . $optionValue . '">Group: ' . $optionName .'</option>';
			}

			$out .= '</optgroup>';
		}

		$out .= '</select>';
		return $out;
	}

	/**
	 * Generates HTML code for  array of checkboxes
	 * @param array $field
	 */
	public function makeMailchimpCheckboxesArray($field, $value) {

		$inputHTML = '';
		$lists = Aops::$dropdownOptions['mailchimp_list'];
		$groupLists = Aops::$dropdownOptions['mailchimp_group_title'];

		$inputHTML .= '<div id="mailchimp_list_none" class="mailchimp-list" style="display:none">Please select list</div>';

		foreach ($lists as $listId => $listTitle) {
			if ((string)$listId != "0") {
				$inputHTML .= '<div class="mailchimp-list" id="mailchimp_list_' . $listId . '" style="display:none">';
				if (count($groupLists[$listId])) {
					foreach ($groupLists[$listId] as $groupTitleId => $groupTitle) {
						$inputHTML .= '<p class="aops-group-title">Group "' .$groupTitle .'"</p>';

						$checkboxesHTML = $this->makeMailchimpCheckboxes($field, $groupTitleId, $value);

						foreach ($checkboxesHTML as $row) {
							$inputHTML .= '<p class="aops-group-item">' . $row . '</p>';
						}
					}
				}
				else {
					$inputHTML .= "<p>No groups in this list</p>";
				}
				$inputHTML .= '</div>';
			}
		}

		return $inputHTML;
	}

	/**
	 * Generates HTML code for array of checkboxes
	 * used in Aops::makeMailchimpCheckboxesArray()
	 *
	 */
	public function makeMailchimpCheckboxes($field, $groupTitleId, $value) {
		$checkboxes = $this->getMailchimpCheckboxesValues($groupTitleId, $value);
		$checkboxesHTML = array();
		foreach ($checkboxes as $checkboxId => $checkbox) {
			$value = $checkbox['value'] ? 'checked="checked"' : '';
			$checkboxesHTML[] = <<<EOT
				<input type="checkbox" id="aops_{$field['id']}_{$groupTitleId}_{$checkboxId}" name="{$field['name']}[{$groupTitleId}][{$checkboxId}]" {$value} value="1" class="cu-checkbox-field"/>
				{$checkbox['name']}
EOT;
		}
		return $checkboxesHTML;
	}

	/**
	 * Generates HTML code for textarea
	 * @param array $field
	 */
	public function makeTextareaField($field, $value) {
		$out = <<<EOT
			<textarea id="aops_{$field['id']}" name="{$field['name']}" cols="{$field['cols']}" rows="{$field['rows']}" value="">{$value}</textarea>
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for textarea
	 * @param array $field
	 */
	public function makeCopyTextareaField($field) {
		$out = <<<EOT
			<div class="aops_copy_textarea"><span onclick="selectText('aops_{$field['id']}')" id="aops_{$field['id']}">{$field['default']}</span></div>
EOT;
		return $out;
	}

	/**
	 * Generates HTML code for editor input in table
	 * @param array $field
	 */
	public function makeRichTextareaField($field, $value) {
		ob_start();
		wp_editor( $value, 'aops_' . $field['id'], array('textarea_name' => $field['name'],'editor_height' => $field['height']) );
		$out = ob_get_clean();
		return $out;
	}

	/**
	 * Generates HTML code for editor input in table
	 * @param array $field
	 */
	public function makeContentUploader($field, $value) {
		if (!$value)
			$buttonLabel = 'Upload bonus content';
		else
			$buttonLabel = 'Update bonus content';

		$out = '<p><a href="javascript:void(0)" class="button button-primary button-large" id="upload_bonus_content_button">' . $buttonLabel . '</a></p>';

		$out .= '<p>Bonus Content File Path: <input type="text" id="aops_' . $field['id'] .'" name="'. $field['name'] .'" value="'.$value.'"></p>';
		return $out;
	}

	public function checkTextField($field, $value) {
		if (isset($field['check_type'])) {

			switch($field['check_type']) {
				case 'option':
					$result = $this->options[$field['check_by']];
					break;
				case 'meta':
					$result = $field['check_by'];
					break;
				case 'value':
					$callback = $field['check_by'];
					$result = $this->$callback($value);
					break;
				default:
					$result = self::STATUS_UNKNOWN;
			}
		}
		else {
			$result = self::STATUS_UNKNOWN;
		}

		return $result;
	}

	public function getMailchimpCheckboxesValues($groupTitleId, $value) {
		$groupTitleId = sprintf('%s',$groupTitleId);

		$groups = Aops::$dropdownOptions['mailchimp_groups'][$groupTitleId];
		$checkboxes = array();
		foreach ($groups as $groupId => $groupName) {
			$groupId = sprintf('%s',$groupId);
			if (is_array($value) && isset($value[$groupTitleId])) {
				$checkboxValue = isset($value[$groupTitleId][$groupId])? $value[$groupTitleId][$groupId] : 0 ;
			}
			else {
				$checkboxValue = false;
			}

			$checkboxes[$groupId] = array(
				'name' => $groupName,
				'value' => $checkboxValue
			);
		}

		return $checkboxes;
	}


	public static function log($data, $debug = false) {
		global $wpdb;

		if ( isset($_REQUEST['aopscu_log_to_screen']) && $_REQUEST['aopscu_log_to_screen'] == 1 ) {
			echo( 'log::<pre>' . print_r($data, 1) . '</pre>' );
		}
		else {
			$enabled = get_option( self::$prefix . 'enable_logging' );

			if ( $enabled ) {
				$table_name = $wpdb->prefix . self::TABLE_LOGS;
				$encoded_data = json_encode( $data );

				if ( ! $encoded_data ) {
					$encoded_data = 'Failed to json_encode the data.';
				}

				if ( strlen( $encoded_data ) > 25600 ) {
					$encoded_data = json_encode( substr($encoded_data, 0, 25600 ) );
				}

				$result = $wpdb->insert(
					$table_name,
					array(
						"data"			=> $encoded_data,
						"created_at"	=> current_time( 'mysql' )
					),
					array("%s", "%s")
				);

				if ( $debug ) {
					echo('<pre> Debug: $result [' . print_r( $result, 1). "]</pre>");
					echo('<br>Debug: $data <br><pre>' . print_r( $data, 1). "</pre>");
					echo('<br>Debug: $encoded_data, length: ' . strlen( $encoded_data ). ' <br><pre>' . print_r( $encoded_data, 1). "</pre>");die();
				}
			}
		}
	}

	public static function getLogs( $date = 0 ) {
		global $wpdb;
		$table_name = $wpdb->prefix . self::TABLE_LOGS;

		$sql = $wpdb->prepare("SELECT * FROM " . $table_name . " WHERE created_at > '%s'", $date);

		$results = $wpdb->get_results($sql, ARRAY_A);

		return $results;
	}

	public static function deleteLog() {
		$filename =  pathinfo( __FILE__, PATHINFO_DIRNAME ) . DIRECTORY_SEPARATOR . 'log.txt';
		if ( is_writable( $filename ) ) {
			$fp = fopen( $filename, 'w');
			fwrite( $fp, 'x' ); // erase contents to be sure
			fclose( $fp );
			@unlink( $filename ); // delete file
		}
	}
}
?>
